/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util.auimlcvt.auiml.tags;

import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TagUtils {
    private TagUtils() {
    }

    public static void buildTableStructure(Document document, Element tableElement, int rows, int cols) {
        int i = 0;
        while (i < rows) {
            Element tr = document.createElement("tr");
            int j = 0;
            while (j < cols) {
                Element td = document.createElement("td");
                td.setAttribute("nowrap", "true");
                tr.appendChild(td);
                ++j;
            }
            tableElement.appendChild(tr);
            ++i;
        }
    }

    public static Element findTable(String name, Document document) {
        NodeList nl = document.getElementsByTagName("table");
        int nlLength = nl.getLength();
        int i = 0;
        while (i < nlLength) {
            if (nl.item(i) instanceof Element && ((Element)nl.item(i)).getAttribute("name").equals(name)) {
                return (Element)nl.item(i);
            }
            ++i;
        }
        return null;
    }

    public static Element findCell(String cell, Element table) {
        Element tr;
        if (cell == null || cell.equals("")) {
            return null;
        }
        int column = Integer.parseInt(cell.substring(0, cell.indexOf(",")));
        int row = Integer.parseInt(cell.substring(cell.indexOf(",") + 1));
        NodeList trs = table.getElementsByTagName("tr");
        int trsLength = trs.getLength();
        int trIndex = -1;
        int x = -1;
        do {
            if (++x == trsLength) {
                tr = table.getOwnerDocument().createElement("tr");
                table.appendChild(tr);
                ++trsLength;
                int colspan = 0;
                int i = 0;
                while (i < trsLength) {
                    if (trs.item(i).getParentNode() == table) {
                        NodeList tds = ((Element)trs.item(i)).getElementsByTagName("td");
                        int tdsLength = tds.getLength();
                        int j = 0;
                        while (j < tdsLength) {
                            Element tdtmp = (Element)tds.item(j);
                            if (tdtmp.getParentNode() == trs.item(i)) {
                                String tdcolspan = tdtmp.getAttribute("colspan");
                                colspan = tdcolspan != null && !tdcolspan.trim().equals("") ? (colspan += Integer.parseInt(tdcolspan)) : ++colspan;
                            }
                            ++j;
                        }
                        i = trsLength;
                    }
                    ++i;
                }
                int i2 = 0;
                while (i2 < colspan) {
                    Element td = table.getOwnerDocument().createElement("td");
                    td.setAttribute("nowrap", "true");
                    tr.appendChild(td);
                    ++i2;
                }
                x = -1;
                trIndex = -1;
                continue;
            }
            if (!trs.item(x).getParentNode().equals(table)) continue;
            ++trIndex;
        } while (trIndex != row);
        tr = (Element)trs.item(x);
        NodeList tds = tr.getElementsByTagName("td");
        int ptr = 0;
        int tdsLength = tds.getLength();
        int i = 0;
        while (i < tdsLength) {
            Element td = (Element)tds.item(i);
            if (td.getParentNode() == tr) {
                if (ptr == column) {
                    return td;
                }
                String colspan = td.getAttribute("colspan");
                ptr = colspan != null && !colspan.trim().equals("") ? (ptr += Integer.parseInt(colspan)) : ++ptr;
            }
            ++i;
        }
        Element td = null;
        while (ptr <= column) {
            td = table.getOwnerDocument().createElement("td");
            td.setAttribute("nowrap", "true");
            tr.appendChild(td);
            ++ptr;
        }
        return td;
    }

    public static Element findElement(String id, Element inElement) {
        if (inElement.getAttribute("id") != null && inElement.getAttribute("id").equals(id)) {
            return inElement;
        }
        NodeList children = inElement.getChildNodes();
        int childrenLength = children.getLength();
        int i = 0;
        while (i < childrenLength) {
            Element returnElement;
            if (children.item(i) instanceof Element && (returnElement = TagUtils.findElement(id, (Element)children.item(i))) != null) {
                return returnElement;
            }
            ++i;
        }
        return null;
    }

    public static void adjustColspan(String colspanStr, Element tdCell) {
        if (colspanStr == null || colspanStr.trim().equals("") || tdCell == null) {
            return;
        }
        int colspan = Integer.parseInt(colspanStr);
        if (colspan == 1) {
            return;
        }
        Element tr = (Element)tdCell.getParentNode();
        NodeList trChildren = tr.getChildNodes();
        int i = 0;
        while (trChildren.item(i) != tdCell) {
            ++i;
        }
        if (colspan == 0) {
            int len = trChildren.getLength();
            int removed = 0;
            int x = len - 1;
            while (x > i) {
                if (trChildren.item(x) instanceof Element && ((Element)trChildren.item(x)).getTagName().equals("td") && trChildren.item(x).getChildNodes().getLength() == 0) {
                    tr.removeChild(trChildren.item(x));
                    ++removed;
                }
                --x;
            }
            colspanStr = new Integer(removed + 1).toString();
        } else {
            int removed = 0;
            int z = i + colspan - 1;
            while (z > i) {
                if (trChildren.item(z) instanceof Element && ((Element)trChildren.item(z)).getTagName().equals("td") && trChildren.item(z).getChildNodes().getLength() == 0) {
                    tr.removeChild(trChildren.item(z));
                    ++removed;
                }
                --z;
            }
            if (removed > 0) {
                colspanStr = new Integer(removed + 1).toString();
            }
        }
        tdCell.setAttribute("colspan", colspanStr);
    }

    public static void adjustRowspan(String rowspanStr, Element tdCell) {
        if (rowspanStr == null || rowspanStr.trim().equals("") || tdCell == null) {
            return;
        }
        int rowspan = Integer.parseInt(rowspanStr);
        if (rowspan == 1) {
            return;
        }
        tdCell.setAttribute("rowspan", rowspanStr);
    }

    public static void removeEmptyRowsFromTables(Document document) {
        if (document == null) {
            return;
        }
        NodeList tables = document.getElementsByTagName("table");
        if (tables == null) {
            return;
        }
        int i = 0;
        while (i < tables.getLength()) {
            Element table = (Element)tables.item(i);
            NodeList trs = table.getElementsByTagName("tr");
            if (trs != null) {
                int j = trs.getLength() - 1;
                while (j >= 0) {
                    Element tr = (Element)trs.item(j);
                    if (tr.getParentNode() == table) {
                        if (TagUtils.isEmptyRow(tr)) {
                            table.removeChild(tr);
                            j = trs.getLength();
                        } else {
                            j = 0;
                        }
                    }
                    --j;
                }
            }
            ++i;
        }
        NodeList tds = document.getElementsByTagName("td");
        if (tds == null) {
            return;
        }
        ArrayList<Node> affectedTds = new ArrayList<Node>();
        int i2 = 0;
        while (i2 < tds.getLength()) {
            if (((Element)tds.item(i2)).getAttribute("rowspan") != null && !((Element)tds.item(i2)).getAttribute("rowspan").equals("")) {
                affectedTds.add(tds.item(i2));
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < affectedTds.size()) {
            TagUtils.fixRowSpan((Element)affectedTds.get(i3));
            affectedTds.remove(i3);
            i3 = -1;
            ++i3;
        }
    }

    private static void fixRowSpan(Element tdCell) {
        Element tr = (Element)tdCell.getParentNode();
        Element table = (Element)tr.getParentNode();
        NodeList tableRows = table.getChildNodes();
        int i = 0;
        int colNum = 0;
        while (tr.getChildNodes().item(i) != tdCell) {
            Element tmpTd = (Element)tr.getChildNodes().item(i);
            if (!tmpTd.getTagName().equals("td")) continue;
            if (tmpTd.getAttribute("colspan") != null && !tmpTd.getAttribute("colspan").equals("")) {
                String colspan = tmpTd.getAttribute("colspan");
                colNum += Integer.parseInt(colspan);
            } else {
                ++colNum;
            }
            ++i;
        }
        i = 0;
        while (tableRows.item(i) != tr) {
            ++i;
        }
        int rowspan = Integer.parseInt(tdCell.getAttribute("rowspan"));
        int colsToFix = 1;
        if (tdCell.getAttribute("colspan") != null && !tdCell.getAttribute("colspan").equals("")) {
            colsToFix = Integer.parseInt(tdCell.getAttribute("colspan"));
        }
        if (rowspan == 0) {
            rowspan = tableRows.getLength() - i;
        }
        if (rowspan == 1) {
            return;
        }
        if (tableRows.getLength() - i < rowspan) {
            rowspan = tableRows.getLength() - i;
        }
        int z = i + 1;
        while (z < i + rowspan) {
            Element tmptr = (Element)tableRows.item(z);
            int y = 0;
            while (y < colNum) {
                Element tmptd = (Element)tmptr.getChildNodes().item(y);
                if (!tmptd.getTagName().equals("td")) continue;
                if (tmptd.getAttribute("colspan") != null && !tmptd.getAttribute("colspan").equals("")) {
                    y += Integer.parseInt(tmptd.getAttribute("colspan"));
                    continue;
                }
                ++y;
            }
            if (y == colNum) {
                int x = 0;
                int numRemoved = 0;
                while (x < colsToFix && y + x - numRemoved < tmptr.getChildNodes().getLength()) {
                    Element tmptd = (Element)tmptr.getChildNodes().item(y + x - numRemoved);
                    x = tmptd.getAttribute("colspan") != null && !tmptd.getAttribute("colspan").equals("") ? (x += Integer.parseInt(tmptd.getAttribute("colspan"))) : ++x;
                    if (tmptd.getChildNodes().getLength() != 0) continue;
                    tmptd.getParentNode().removeChild(tmptd);
                    ++numRemoved;
                }
            }
            ++z;
        }
    }

    private static boolean isEmptyRow(Element tr) {
        if (tr == null) {
            return true;
        }
        if (tr.getChildNodes() == null || tr.getChildNodes().getLength() == 0) {
            return true;
        }
        NodeList tds = tr.getElementsByTagName("td");
        if (tds == null || tds.getLength() == 0) {
            return true;
        }
        int i = 0;
        while (i < tds.getLength()) {
            if (tds.item(i).getParentNode() == tr && tds.item(i).getChildNodes().getLength() > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Element findParentWithTagName(Element element, String tagName) {
        if (tagName == null) {
            return element;
        }
        Element tmp = element;
        while (tmp != null && !tmp.getTagName().equals(tagName)) {
            tmp = tmp.getParentNode() instanceof Element ? (Element)tmp.getParentNode() : null;
        }
        return tmp;
    }

    public static String adjustImageSrcPath(String path) {
        if (path == null) {
            return "";
        }
        if (path.indexOf("graphic") <= 6 && path.indexOf("graphic") >= 0) {
            return path;
        }
        int lastDot = path.lastIndexOf(".");
        int dot = path.indexOf(".");
        while (dot != lastDot) {
            path = path.substring(0, dot) + "/" + path.substring(dot + 1);
            dot = path.indexOf(".");
        }
        return "/res/" + path;
    }
}

